<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
    <title>RegisterAkun - Laundry</title>
    <!-- General CSS Files -->
    <link rel="stylesheet" href="assets/css/app.min.css">
    <link rel="stylesheet" href="assets/bundles/jquery-selectric/selectric.css">
    <!-- Template CSS -->
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/components.css">
    <!-- Custom style CSS -->
    <link rel="stylesheet" href="assets/css/custom.css">
    <link rel='shortcut icon' type='image/png' href='assets/img/laundry.png' />

</head>

<body>
    <div class="loader"></div>
    <div id="app">
        <section class="section">
            <div class="container mt-5">
                <div class="row">
                    <div
                        class="col-12 col-sm-10 offset-sm-1 col-md-8 offset-md-2 col-lg-8 offset-lg-2 col-xl-8 offset-xl-2">
                        <div class="card card-primary">
                            <div class="card-header">
                                <h4>Register</h4>
                            </div>
                            <div class="card-body">
                                <form method="POST" action="<?php echo e(route('register')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <div class="form-group">
                                        <label for="username">Username</label>
                                        <input id="username" type="text" class="form-control" name="username">
                                        <div class="invalid-feedback">
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="form-group col-6">
                                            <label for="password" class="d-block">Password</label>
                                            <input id="password" type="password" class="form-control pwstrength"
                                                data-indicator="pwindicator" name="password">
                                            <div id="pwindicator" class="pwindicator">
                                                <div class="bar"></div>
                                                <div class="label"></div>
                                            </div>
                                        </div>
                                        <div class="form-group col-6">
                                            <label for="password_confirmation" class="d-block">Konfirmasi
                                                Password</label>
                                            <input id="password2" type="password" class="form-control"
                                                name="password_confirmation"> <!-- Perubahan di sini -->
                                        </div>
                                    </div>
                            </div>
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary btn-lg btn-block">
                                    Daftar
                                </button>
                            </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
    </div>
    </section>
    </div>
    <!-- General JS Scripts -->
    <script src="assets/js/app.min.js"></script>
    <!-- JS Libraies -->
    <script src="assets/bundles/jquery-pwstrength/jquery.pwstrength.min.js"></script>
    <script src="assets/bundles/jquery-selectric/jquery.selectric.min.js"></script>
    <!-- Page Specific JS File -->
    <script src="assets/js/page/auth-register.js"></script>
    <!-- Template JS File -->
    <script src="assets/js/scripts.js"></script>
    <!-- Custom JS File -->
    <script src="assets/js/custom.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <?php if(session('success')): ?>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            Swal.fire({
                title: 'Sukses!',
                text: '<?php echo e(session('success')); ?>',
                icon: 'success',
                confirmButtonText: 'Ok'
            });
        });
    </script>
    <?php endif; ?>

    <!-- SweetAlert for Validation Errors -->
    <?php if($errors->any()): ?>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            var errors = <?php echo json_encode($errors -> getMessages(), 15, 512) ?>;

            // Cek error username terlebih dahulu
            if (errors.username) {
                Swal.fire({
                    title: 'Error!',
                    text: errors.username[0], // Pesan error pertama untuk username
                    icon: 'error',
                    confirmButtonText: 'Ok'
                });
            } else if (errors.password) {
                // Jika tidak ada error username, cek error password
                Swal.fire({
                    title: 'Error!',
                    text: errors.password[0], // Pesan error pertama untuk password
                    icon: 'error',
                    confirmButtonText: 'Ok'
                });
            }
        });
    </script>
    <?php endif; ?>


</body>

</html><?php /**PATH C:\Users\Iluvia\Desktop\WebLaundryV2\resources\views/Login/regis.blade.php ENDPATH**/ ?>