

<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-header">
        <h4>Data Order</h4>
    </div>
    <div class="card-body">
        <!-- Tambahkan button di sini -->
        <div class="buttons">
            <a href="#" class="btn btn-icon icon-left btn-primary" data-toggle="modal"
                data-target="#tambahDataOrderModal"><i class="far fa-edit"></i> Tambah Data Order</a>
        </div>
        <div class="table-responsive">
            <table class="table table-striped table-hover" id="tableExport" style="width:100%;">
                <thead>
                    <tr>
                        <th class="d-none">ID</th>
                        <th>No</th>
                        <th>Nomor Order</th> <!-- Kolom "Nomor Order" yang baru ditambahkan -->
                        <th>Kode Paket</th>
                        <th>Nama Pelanggan</th>
                        <th>Berat Per Kg</th>
                        <th>Total</th>
                        <th>Tanggal Ambil</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $dataOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dataOrder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="d-none"><?php echo e($dataOrder->id); ?></td>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td><?php echo e($dataOrder->no_order); ?></td> <!-- Menampilkan Nomor Order -->
                        <td><?php echo e($dataOrder->kode_paket); ?></td>
                        <td><?php echo e($dataOrder->nama_pelanggan); ?></td>
                        <td><?php echo e($dataOrder->berat_per_kg); ?></td>
                        <td>RP <?php echo e(number_format($dataOrder->berat_per_kg * $dataOrder->dataPaket->harga_per_kg, 0, ',',
                            '.')); ?></td>
                        <td><?php echo e($dataOrder->tanggal_ambil); ?></td>
                        <td>
                            <?php if($dataOrder->status === 'OnProcess'): ?>
                            <div class="badge badge-info">OnProcess</div>
                            <?php elseif($dataOrder->status === 'Ready'): ?>
                            <div class="badge badge-warning">Ready</div>
                            <?php elseif($dataOrder->status === 'Completed'): ?>
                            <div class="badge badge-success">Completed</div>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($dataOrder->status === 'OnProcess'): ?>
                            <!-- Tombol Edit dan Hapus -->
                            <a href="#" class="btn btn-icon btn-warning" data-toggle="modal"
                                data-target="#editDataOrderModal<?php echo e($dataOrder->id); ?>">
                                <i class="fas fa-edit"></i>
                            </a>
                            <a href="#" class="btn btn-icon btn-success update-status-order"
                                data-id="<?php echo e($dataOrder->id); ?>">
                                <i class="fas fa-check"></i>
                            </a>
                            <a href="#" class="btn btn-icon btn-danger delete-data-order"
                                data-id="<?php echo e($dataOrder->id); ?>"><i class="fas fa-times"></i></a>
                            <a href="#" class="btn btn-icon btn-primary cetak-order" data-id="<?php echo e($dataOrder->id); ?>">
                                <i class="fas fa-print"></i> Cetak
                            </a>
                            <?php elseif($dataOrder->status === 'Ready' || $dataOrder->status === 'Completed'): ?>
                            <!-- Tombol Detail Transaksi -->
                            <a href="#" class="btn btn-icon btn-info detail-transaksi-order"
                                data-id="<?php echo e($dataOrder->id); ?>">
                                <i class="far fa-eye"></i> Detail Transaksi
                            </a>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('Layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Wawan\Downloads\WebLaundryV2\resources\views/Menu/dataorder.blade.php ENDPATH**/ ?>