<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
    <title>Login - Laundry</title>
    <!-- General CSS Files -->
    <link rel="stylesheet" href="assets/css/app.min.css">
    <link rel="stylesheet" href="assets/bundles/bootstrap-social/bootstrap-social.css">
    <!-- Template CSS -->
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/components.css">
    <!-- Custom style CSS -->
    <link rel="stylesheet" href="assets/css/custom.css">
    <link rel='shortcut icon' type='image/png' href='assets/img/laundry.png' />

    <style>

        body {
            overflow: hidden;
        }
        .center-container {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            position: relative;
            overflow: hidden;
        }

        .card-container {
            position: relative;
            z-index: 1;
        }

        .background-image {
            position: fixed;
            top: 50%;
            left: 50%;
            width: 100%;
            height: 100%;
            background-image: url('assets/img/background.jpg');
            background-size: cover;
            filter: blur(2px);
            opacity: 0.4;
            z-index: -1;
            transform: translate(-50%, -50%);
        }

    </style>
</head>

<body class="light light-sidebar theme-white">
    <div class="loader" style="display: none;"></div>
    <div id="app">
        <section class="section">
            <div class="container mt-5 center-container card-container">
                <div class="background-image"></div>
                <div class="row justify-content-center">
                    <div class="col-md-6">
                        <div class="card card-primary">
                            <div class="card-body">
                                <div class="row justify-content-center align-items-center">
                                    <div class="col-md-6">
                                        <h4 class="text-center mb-4">Login</h4>
                                        <form method="POST" action="<?php echo e(route('masuk')); ?>" class="needs-validation" novalidate="">
                                            <?php echo csrf_field(); ?>
                                            <div class="form-group">
                                                <label for="username">Username</label>
                                                <input id="username" type="text" class="form-control" name="username" tabindex="1" required="" autofocus="">
                                                <div class="invalid-feedback">
                                                    Please fill in your username
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="d-block">
                                                    <label for="password" class="control-label">Password</label>
                                                </div>
                                                <input id="password" type="password" class="form-control" name="password" tabindex="2" required="">
                                                <div class="invalid-feedback">
                                                    Please fill in your password
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <button type="submit" class="btn btn-primary btn-lg btn-block" tabindex="4">
                                                    Login
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="col-md-6 mb-4">
                                        <img src="assets/img/logo_edan.png" alt="Laundry Logo" style="max-width: 100%;">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <!-- General JS Scripts -->
    <script src="assets/js/app.min.js"></script>
    <!-- JS Libraies -->
    <!-- Page Specific JS File -->
    <!-- Template JS File -->
    <script src="assets/js/scripts.js"></script>
    <!-- Custom JS File -->
    <script src="assets/js/custom.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <?php if($errors->any()): ?>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            var errors = <?php echo json_encode($errors -> getMessages(), 15, 512) ?>;

            if (errors.login_error) {
                Swal.fire({
                    title: 'Error!',
                    text: errors.login_error[0],
                    icon: 'error',
                    confirmButtonText: 'Ok'
                });
            }
        });
    </script>
    <?php endif; ?>

</body><!-- auth-login.html  21 Nov 2019 03:49:32 GMT -->

</html>
<?php /**PATH C:\Users\Wawan\Downloads\WebLaundryV2\resources\views/Login/login.blade.php ENDPATH**/ ?>