

<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-header">
        <h4>Data Pengambilan</h4>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped table-hover" id="tableExport" style="width:100%;">
                <thead>
                    <tr>
                        <th class="d-none">ID</th>
                        <th>No</th>
                        <th>Nomor Order</th>
                        <th>Kode Paket</th>
                        <th>Nama Pelanggan</th>
                        <th>Berat Per Kg</th>
                        <th>Total</th>
                        <th>Diambil</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $dataOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dataOrder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($dataOrder->status === 'Ready' || $dataOrder->status === 'Completed'): ?>
                    <tr>
                        <td class="d-none"><?php echo e($dataOrder->id); ?></td>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td><?php echo e($dataOrder->no_order); ?></td>
                        <td><?php echo e($dataOrder->kode_paket); ?></td>
                        <td><?php echo e($dataOrder->nama_pelanggan); ?></td>
                        <td><?php echo e($dataOrder->berat_per_kg); ?></td>
                        <td>RP <?php echo e(number_format($dataOrder->berat_per_kg * $dataOrder->dataPaket->harga_per_kg, 0, ',',
                            '.')); ?></td>
                        <td>
                            <?php if($dataOrder->status === 'Ready'): ?>
                            <div class="badge badge-danger">BelumDiambil</div>
                            <?php else: ?>
                            <?php echo e($dataOrder->Diambil); ?>

                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($dataOrder->status === 'Ready'): ?>
                            <div class="badge badge-warning">Ready</div>
                            <?php elseif($dataOrder->status === 'Completed'): ?>
                            <div class="badge badge-success">Completed</div>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($dataOrder->status === 'Completed'): ?>
                            <!-- Tombol Detail Transaksi hanya muncul jika status Completed -->
                            <a href="#" class="btn btn-icon btn-info detail-transaksi-ambil"
                                data-id="<?php echo e($dataOrder->id); ?>">
                                <i class="far fa-eye"></i> Detail Transaksi
                            </a>
                            <?php endif; ?>
                            <?php if($dataOrder->status === 'Ready'): ?>
                            <!-- Tombol Update hanya muncul jika status Ready -->
                            <a href="#" class="btn btn-icon btn-success update-status-ambil"
                                data-id="<?php echo e($dataOrder->id); ?>">
                                <i class="fas fa-check"></i> Update Status
                            </a>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('Layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Iluvia\Desktop\WebLaundryV2\resources\views/Menu/datapengambilan.blade.php ENDPATH**/ ?>